/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.client_bound;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.BlockScreen;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.net.Packet;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Rotation;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3i;

public class S2CMessageAddScreen
extends Packet {
    private boolean clear;
    private Vector3i pos;
    private TileEntityScreen.Screen[] screens;

    public S2CMessageAddScreen(TileEntityScreen tes) {
        this.clear = true;
        this.pos = new Vector3i(tes.m_58899_());
        this.screens = new TileEntityScreen.Screen[tes.screenCount()];
        for (int i = 0; i < tes.screenCount(); ++i) {
            this.screens[i] = tes.getScreen(i);
        }
    }

    public S2CMessageAddScreen(TileEntityScreen tes, TileEntityScreen.Screen ... toSend) {
        this.clear = false;
        this.pos = new Vector3i(tes.m_58899_());
        this.screens = toSend;
    }

    public S2CMessageAddScreen(boolean clear, Vector3i pos, TileEntityScreen.Screen[] screens) {
        this.clear = clear;
        this.pos = pos;
        this.screens = screens;
    }

    public S2CMessageAddScreen(FriendlyByteBuf buf) {
        super(buf);
        this.clear = buf.readBoolean();
        this.pos = new Vector3i((ByteBuf)buf);
        int cnt = buf.readByte() & 7;
        this.screens = new TileEntityScreen.Screen[cnt];
        for (int i = 0; i < cnt; ++i) {
            this.screens[i] = new TileEntityScreen.Screen();
            this.screens[i].side = BlockSide.values()[buf.readByte()];
            this.screens[i].size = new Vector2i((ByteBuf)buf);
            this.screens[i].url = buf.m_130277_();
            this.screens[i].resolution = new Vector2i((ByteBuf)buf);
            this.screens[i].rotation = Rotation.values()[buf.readByte() & 3];
            this.screens[i].owner = new NameUUIDPair(buf);
            this.screens[i].upgrades = new ArrayList();
            int numUpgrades = buf.readByte();
            for (int j = 0; j < numUpgrades; ++j) {
                this.screens[i].upgrades.add(buf.m_130267_());
            }
        }
    }

    @Override
    public void m_5779_(FriendlyByteBuf buf) {
        buf.writeBoolean(this.clear);
        this.pos.writeTo((ByteBuf)buf);
        buf.writeByte(this.screens.length);
        for (TileEntityScreen.Screen scr : this.screens) {
            buf.writeByte(scr.side.ordinal());
            scr.size.writeTo((ByteBuf)buf);
            buf.m_130070_(scr.url);
            scr.resolution.writeTo((ByteBuf)buf);
            buf.writeByte(scr.rotation.ordinal());
            scr.owner.writeTo(buf);
            buf.writeByte(scr.upgrades.size());
            for (ItemStack is : scr.upgrades) {
                buf.m_130055_(is);
            }
        }
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (this.checkClient(ctx)) {
            ctx.enqueueWork(() -> {
                Level lvl = (Level)WebDisplays.PROXY.getWorld(ctx);
                BlockEntity te = lvl.m_7702_(this.pos.toBlock());
                if (!(te instanceof TileEntityScreen)) {
                    lvl.m_46597_(this.pos.toBlock(), (BlockState)lvl.m_8055_(this.pos.toBlock()).m_61124_((Property)BlockScreen.hasTE, (Comparable)Boolean.valueOf(true)));
                    te = lvl.m_7702_(this.pos.toBlock());
                    if (!(te instanceof TileEntityScreen)) {
                        if (this.clear) {
                            Log.error("CMessageAddScreen: Can't add screen to invalid tile entity at %s", this.pos.toString());
                        }
                        return;
                    }
                }
                TileEntityScreen tes = (TileEntityScreen)te;
                if (this.clear) {
                    tes.clear();
                }
                for (TileEntityScreen.Screen entry : this.screens) {
                    String webUrl;
                    TileEntityScreen.Screen scr = tes.addScreen(entry.side, entry.size, entry.resolution, null, false);
                    scr.rotation = entry.rotation;
                    try {
                        webUrl = TileEntityScreen.url(entry.url);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    scr.url = webUrl;
                    scr.owner = entry.owner;
                    scr.upgrades = entry.upgrades;
                    if (scr.browser == null) continue;
                    scr.browser.loadURL(webUrl);
                }
            });
            ctx.setPacketHandled(true);
        }
    }
}

